;  Version 3.3
; Scripts for Outlook Express 
; Copyright 1998 by Henter-Joyce, Inc.
; 9/29/98, A.Gonzalez.
; Updated 9/99, D.B
; Added changes for VirtualPCCursor
;Check JCF Option for Virtual PC Cursor when deleting messages, 
;switch it on so as not to check against CaretVisible ()
;for more stable performance when deleting highlighted text when composing message
;Also see Message navigation scripts for new VCursor performance
;Get rid of Refresh when new functionality available to redraw the window more quickly
; Neither RefreshWindow nor IEUpdate were consistent enough in re-capturing the buffer

include "msimnui.jsh"
include "msimnui.jsm"
Include "hjconst.jsh"
Include "hjglobal.jsh"
use "magOExp.jsb"
globals
; the handle to a window containing an HTML document
; that should be read automatically.
; This handle is set when the WindowCreatedEvent detects that a window
; of class "Internet Explorer_Server"
; has been created.
; The SayFocusedWindow function then checks to see if
; the window gaining focus has this same handle.  If so,
; it fires the DocumentLoadedEvent and sets the handle to null.
handle oe_hWindowNewHTMLDocument

Function AutoFinishEvent ()
;var
;	object null
;let ieCurrentDocument = null
TurnSuppressCheckForBoldOff ()
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Outlook Express ")
EndScript

Script GotoAttachmentsList ()
var
	int iCount, 
	handle winHandle
let iCount = 0;
If (GetWindowClass (GetCurrentWindow ()) == wc_ListView) then 
	SayWindowTypeAndText (GetFocus ())
	Return
EndIf
let winHandle = GetAppMainWindow (GetFocus ());
if (GetWindowClass (winHandle) != wc_message) then
; not in an open message 
	Say(msg_NoOpenMessage, ot_message);
	return;
EndIf
SaveCursor ()
let winHandle = FindDescendantWindow (winHandle, subject_field)
JawsCursor ()
MoveToWindow (winHandle)
let winHandle = GetCurrentWindow ()
While ((GetWindowClass (winHandle) != wc_ListView) && (iCount <= 6))
	let winHandle = GetPriorWindow (winHandle)
	JawsCursor ()
	MoveToWindow (winHandle)
	let iCount = iCount + 1
;	Pause ()
EndWhile
if GetWindowClass (winHandle) == wc_ListView && (not IsWindowObscured (winHandle)) then 
	LeftMouseButton ()
else
	RestoreCursor ()
	Say(msg_NoAttachments, ot_message);
EndIf
EndScript

Script GoToMessageField ()
var
	int iCount,
	handle winHandle
let iCount = 0;
If (GetWindowClass (GetFocus ()) == ie4Class) then
	Say (msg49, OT_MESSAGE); "Already in Message Body Window"
	Return
EndIf
let winHandle = GetAppMainWindow (GetFocus ())
if (GetWindowClass (winHandle) != wc_message) then
; not in an open message 
	Say(msg_NoOpenMessage, ot_message);
	return;
EndIf
SaveCursor ()
let winHandle = FindDescendantWindow (winHandle, subject_field)
JawsCursor ()
	MoveToWindow (winHandle)
let winHandle = GetCurrentWindow ()
While ((GetWindowClass (winHandle) != wc_message_body ) && (iCount < 6))
	NextLine ()
	let winHandle = GetCurrentWindow ()
	Pause ()
	let iCount = iCount + 1
EndWhile
if GetWindowClass (winHandle) == ie4Class then
	JawsCursor ();
	LeftMouseButton ()
else
	Say(msg_NoOpenMessage, ot_message);
EndIf
EndScript

HANDLE Function GetHeaderWindow ()
return FindDescendantWindow (GetAppMainWindow (GetFocus ()), message_header);
EndFunction

HANDLE Function GetHeaderControl (int cId)
return FindDescendantWindow (GetHeaderWindow (), cId)
EndFunction

Void Function FocusWindow (handle hwnd)
var
	int subTypeCode
SaveCursor ()
JawsCursor ()
MoveToWindow (hwnd)
pause ()
LeftMouseButton ()
let subTypeCode = GetWindowSubTypeCode (hwnd) 
if ((subTypeCode == wt_combobox) || 
	(subTypeCode == wt_checkbox)) then
	LeftMouseButton ()
EndIf
RestoreCursor ()
EndFunction

Void Function ReadHeaderControl (int controlId)
var
	handle winHandle
let winHandle = GetHeaderControl (controlId)
if (winHandle && IsWindowVisible (winHandle)) then
	if IsSameScript () then
	If (GetWindowClass (GetFocus ()) == wc_List) then
		ControlNotFound (controlId)
		Return
	EndIf
		FocusWindow (winHandle)
		return
	EndIf
If (GetWindowClass (GetFocus ()) == wc_List) then
	ControlNotFound (controlId)
	Return
EndIf
	ReadPrompt (controlId)
	if (GetWindowSubTypeCode (winHandle) == wt_checkbox) then
		SayWindowTypeAndText (winHandle)
	;else
		;SayWindow (winHandle, read_everything)
	EndIf
	if (GetVerbosity () == beginner) then
		Say(msg1, ot_message); " Press twice to edit "
	EndIf
else
	ControlNotFound (controlId)
EndIf
EndFunction

Void Function ReadPrompt (int cId)
var
	handle hwnd
let hwnd = GetHeaderControl (cId);
if hwnd then
	SaveCursor ();
	InvisibleCursor ();
	MoveToWindow (hwnd);
	JawsHome ();
	;SayWord ();
	SayWindowTypeAndText (hWnd)
	RestoreCursor ();
EndIf
EndFunction

Void Function ControlNotFound (int cId)
var
	string str
if (cId == from_field) then
	let str = msg_from;
ElIf (cId == from_Field2) then
	let str = msg_from;
elif (cId == date_field) then
	let str = msg_date;
elif (cId == to_field) then
	let str = msg_to;
elif (cId == cc_field) then
	let str = msg_cc;
elif (cId == bcc_field) then
	let str = msg_bcc;
elif (cId == subject_field) then
	let str = msg_subject;
EndIf
let str = str + msg_FieldNotFound;
Say(str, ot_buffer);
EndFunction

Script ReadFromField ()
ReadHeaderControl (From_Field2)
EndScript

Script ReadDateField ()
ReadHeaderControl (date_field);
EndScript

Script ReadToField ()
ReadHeaderControl (to_field);
EndScript

Script ReadCcField ()
ReadHeaderControl (cc_field);
EndScript

Script ReadBccField ()
ReadHeaderControl (Bcc_field);
EndScript

Script ReadSubjectField ()
ReadHeaderControl (subject_field);
EndScript

Function FocusChangedEvent (handle focusWindow, handle prevWindow)
; The default FocusChangedEvent function has been modified to smooth going back and forth from the app 
; to the JAWS Select Item in List dialog
var
	handle RealWindow,
	string RealWindowName,
	string sPrevClass,; class of previous window 
	string sNowClass,; class of focused window
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
let sPrevClass = GetWindowClass (PrevWindow)
let sNowClass = GetWindowClass (FocusWindow)

If ((sPrevClass == WC_List) && (SNowClass == ie4Class)) then
	Pause ()
	Pause ()
EndIf
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	; but first check that you are not moving between the app and the JAWS Select Item dialog
	if (GetWindowClass (GlobalPrevApp) == wc_JAWS) then
		let GlobalFocusWindow = FocusWindow
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		return
	EndIf
	if (GetWindowClass (appWindow) != wc_JAWS) then
		SayWindowTypeAndText(AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SayFocusedWindow ()
var
	int iVerbosity,
	handle hNull,
	handle hWnd,
	string theClass,
	int controlId
if (GetWindowTypeCode(globalFocusWindow) == wt_Edit) then
; We are composing a message, don't read anything automatically
let oe_hWindowNewHTMLDocument = hNull
EndIf

let theClass = GetWindowClass (globalFocusWindow);
let controlId = GetControlId (GetFocus ())
if (theClass == ie4Class) then
	if (controlId == to_Field) || (controlId == attachments_list) then
		SayWindowTypeAndText (GetCurrentWindow ())
		Return
	EndIf
	if CaretVisible () then
		Say(msg50, ot_control_name); "Edit "
if  (globalFocusWindow == oe_hWindowNewHTMLDocument) then
	let oe_hWindowNewHTMLDocument = hNull
	let iVerbosity = GetVerbosity ()
	let hWnd = GetHeaderControl (From_Field2)
	; only do following fields if Outlook Today is not open
	If ((hWnd) && IsWindowVisible (hWnd)) then
		While (GetVerbosity () != Intermediate)
			VerbosityLevel ()
		EndWhile
		PerformScript ReadFromField()
		PerformScript ReadSubjectField()
		While (GetVerbosity () != iVerbosity)
			VerbosityLevel ()
		EndWhile
	EndIf
	DocumentLoadedEvent()
	Endif
		return
	EndIf
	return
EndIf
let controlId = GetControlId (globalFocusWindow);
if (controlId == ChangeTo_field) then
	if (GetWindowName (GetParent (GlobalFocusWindow)) == "Spelling") then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if ((controlId == attachments_list) &&
	(GetWindowSubTypeCode (globalFocusWindow) == wt_listview)) then
	Say(msg_attachments, ot_message)
EndIf
SayFocusedObject ()
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, 
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
		SayHighlightedText(hwnd,buffer, nAttributes)
	else
		SayNonHighlightedText(hwnd,buffer)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say(buffer, ot_buffer)
	endif
endif
EndFunction

Void Function TurnSuppressCheckforBoldOff ()
let scheduledFunctionId = 0
let nSuppressCheckForBold = false
EndFunction

Void Function SayHighlightedText (handle hwnd, string buffer, int nattributes)
var
	int controlId
let controlId = GetControlId (hwnd);
if IsMessagesList (hwnd) then
	if !nSuppressCheckForBold then
	;the nSuppressCheckForBold is used here to avoid repetition of "unread message" message
	;the ScheduleFuction is used to set a timer to turn this global back to off
		if (nAttributes & attrib_bold) then
			Say(msg_UnreadMessage, ot_message);
			let nSuppressCheckForBold = true;
			if scheduledFunctionId then
				UnScheduleFunction (scheduledFunctionId)
			EndIf
			let scheduledFunctionId = ScheduleFunction (msg57, 2)
		EndIf
	EndIf
EndIf
if (controlId == ChangeTo_field) then
	if (GetWindowName (GetParent (GlobalFocusWindow)) == "Spelling") then
		PerformScript ReadMisspelledAndSuggestion ()
		return
	EndIf
EndIf
if ((GetScreenEcho() > 0) && !nSuppressEcho) Then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
if (nSuppressEcho) then
	return
EndIf
let TheClass = GetWindowClass(hwnd)
if (TheClass == ie4Class) then
	if (GetWindowClass (GetFocus ()) == ie4Class) then
		if (globalMenuMode == menu_inactive) then
			if !CaretVisible () then
				Say (buffer, OT_BUFFER)
				Return
			EndIf
		EndIf
	EndIf
EndIf
if ((GetScreenEcho() > 1)
	|| (TheClass == "#32771")) then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Void Function MoveToLink (int nNext)
var
int bNeedToSuppressEcho
if  (GetWindowClass(GetFocus()) == ie4Class) then
let bNeedToSuppressEcho = TRUE
endif
; 1 = next, 0 = previous
if (nNext > 0) then
	{Tab}
else
	{Shift+Tab}
EndIf
if (bNeedToSuppressEcho) then
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
pause ()
let nSuppressEcho = false
EndIf
EndFunction

Script MoveToNextLink ()
MoveToLink(1)
EndScript

Script MoveToPriorLink ()
MoveToLink(0)
EndScript

Void Function NewSelectLink ()
if (!DlgListOfLinks()) then
	Say(msg37, ot_message) ;"No links found on page "
endif
EndFunction

Script ReformatDocument ()
If (IsVirtualPcCursor ()) then
	Say (msg60, OT_MESSAGE); "not available in virtual PC cursor mode"
	Return
EndIf
if (ieReformatBody(GetFocus())) then
	Say(msg2, ot_message); "Reformatting message "
else
	Say(msg3, ot_message); "Reformatting failed.  Document may not have finished loading"
Endif
EndScript

Script SayWindowPromptAndText ()
var
	int iControl,
	string sClass
let iControl = GetControlId (GetCurrentWindow ())
let sClass = GetWindowClass (GetCurrentWindow ())
if ((sClass == ie4Class) && (iControl == Attachments_list) || (iControl == To_Field)) then
	SayWindowTypeAndText (GlobalFocusWindow)
	Return
EndIf
SayFocusedObject ()
EndScript

Script SelectALink ()
var
	object doc,
	object links,
	object all,
	int nLinks,
	string buffer,
	string strTemp,
	int nIdx
If (IsVirtualPcCursor ()) then
	NewSelectLink ()
	Return
EndIf
let doc = ie4GetCurrentDocument ()
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then
	Say(msg4, ot_message); "No links found on page "
	return
endif
let nIdx = 0
while (nIdx < nLinks)
	let strTemp = links(nIdx).InnerText
	if (!strTemp) then
		let strTemp = all(links(nIdx).SourceIndex+1).alt
	endif
	if (!strTemp) then
		let strTemp = links(nIdx).href
	endif
	let buffer = buffer + "|" + strTemp
	let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, "Select a Link", true)
if (nIdx == 0) then
	return
endif
doc.links(nIdx-1).click
EndScript

Int Function ieFocusToFirstField ()
var
	object doc,
	object all,
	object forms,
	int nIdx,
	object element,
	string theType
let doc = ie4GetCurrentDocument()
if (!doc) then
	return FALSE
endif
let forms = doc.forms
if (forms.length <= 0 ) then
	return FALSE
endif
let nIdx = forms(0).SourceIndex()
let all = doc.all
while (nIdx < all.length)
	let element = all(nIdx)
	let TheType = element.type
	if (TheType != "" &&
		TheType != "hidden") then
		element.focus
		return TRUE
	endif
	let nIdx = nIdx+1
endwhile
return FALSE
EndFunction

Script FocusToFirstField ()
let nSuppressEcho = TRUE
if (ieFocusToFirstField ()) then
	Beep()
	ProcessNewText()
else
	Say(msg32, ot_message); "Input field not found"
Endif
let nSuppressEcho = FALSE
EndScript

Script ReadMisspelledAndSuggestion ()
var
	handle winHandle
let winHandle = GetParent (GetFocus ())
if (GetWindowName (winHandle) == "Spelling") Then
	if (ToggleRestriction ()) then
		ToggleRestriction () 
	EndIf ; if restriction on
	SaveCursor ()
	InvisibleCursor()
	MoveToControl (winHandle, NotInDictionary_field)
	If (GetVerbosity () > beginner) then
		SayWord ()
	Else
		SayLine ()
	EndIf
	SpellString (GetWord())
	; now see if there are any suggestions
	if MoveToControl (winHandle, suggestions_listbox) then
		if StringContains (GetChunk (), "no suggestions") then
			Say(msg5, ot_message); "No suggestions"
		else
			MoveToControl (winHandle, changeTo_field)
			if (GetVerbosity () > beginner) then
				SayWord ()
			else
				SayLine ()
			EndIf ; verbosity
			SpellWord ()
		EndIf ; no suggestions
	EndIf
	RestoreCursor ()
Else
	Say(msg33, ot_message); "Not in spell checker"
EndIf
EndScript

Int Function IsMessagesList (handle hwnd)
If (GetWindowClass (hWnd) == wc_List) then
	if (GetWindowClass (GetParent (hwnd)) == wc_messagesList_parent5) then
		return true;
	EndIf
EndIf
return false;
EndFunction

Script HotKeyHelp ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
if ((TheClass == ie4Class) || 
	(GetWindowClass (GetParent (WinHandle)) == ie4Class)) then
		Say(msg8 +; "To move forward and backward through links and other controls, use "
		GetScriptKeyName ("MoveToNextLink") + " and " + 
		GetScriptKeyName ("MoveToPriorLink") + " Respectively. ", ot_help)
		Say(msg9 + ; "To read the selected link or control, use "
		GetScriptKeyName ("SayWindowPromptAndText"), ot_help)
		Say(msg10 +; "To select a link from a list of all the links contained in the document, use "
		GetScriptKeyName ("SelectALink"), ot_help)
		Say(msg12 +; "To go to the first form field on the document, use "
		GetScriptKeyName ("FocusToFirstField"), ot_help)
	return
EndIf
let winHandle = GetAppMainWindow (winHandle)
let theClass = GetWindowClass (winHandle)
if (theClass == wc_MainAppWindow) then
	Say(msg13 +; "To click a button in the toolbar, use "
	GetScriptKeyName ("Toolbar"), ot_help)
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script ScreenSensitiveHelp ()
var
	int iControl,
	handle hwnd,
	String TheClass

if (IsSameScript ()) then
	AppFileTopic ()
	return
endif

let hwnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
Let TheClass = GetWindowClass (hwnd)
; for message and address book list
If (TheClass == wc_List) then 
	Say (msg51, OT_HELP); "This is a list view"
	Say (msg52, OT_HELP); "use the arrow keys to read through the items"
	Say (msg53, OT_HELP); "or press the first letter to jump to a desired item"
	Say (msg54, OT_HELP); "items can be contained in one or more columns"
	Say (msg55, OT_HELP); "to select a contiguous group of items",
	Say (msg55A, OT_HELP); "hold down the shift key as you arrow up or down"
	Say (msg56, OT_HELP); "Press the tab key to move to the next control"
	Return;
EndIf;
if (TheClass == ie4Class) then
	if GetHelpWindow () then
		Say(msg14, ot_help); "This is the help topic window "
		Say(msg15, ot_help); "in which you can read the currently loaded document. "
		Say(msg16 +; "To switch to the left pane in the help window, use "
				GetScriptKeyName ("NextDocumentWindow") + ". ", ot_help)
		Say(msg17 + ; "To select a page, press "
				GetScriptKeyName ("SelectHelpTab") + ". ", ot_help)
		Say(msg18 + ; "For more JAWS hotkeys, press "
				GetScriptKeyName ("HotKeyHelp") + ". ", ot_help)
		return
	EndIf
	Say(msg19, ot_help); "This is the message body window "
	Say(msg20, ot_help); "in which you can read or compose a message. "
	Say(msg21, ot_help); "Press insert plus h to get a list of hot keys "
	return
EndIf
if IsLinksList (hwnd) then
	Say(msg22, ot_help); "This is a list of all the links contained on the current message. "
	Say(msg23, ot_help); "Select a link using the arrow keys or the first letter "
	Say(msg24, ot_help); "and press enter to go to it. "
	return
EndIf
if IsToolbarList (hwnd) then
	Say(msg25, ot_help); "this is a list of the buttons in the Outlook Express toolbar. "
	Say(msg26, ot_help); "Select a button using the arrow keys or the first letter of the label "
	Say(msg27, ot_help); "and hit enter to click on it. "
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Int Function IsLinksList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectALinkDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

HANDLE Function GetToolbar ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && 
	GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction

HANDLE Function GetHelpToolbar (handle helpWindow)
var
	handle WinHandle
let WinHandle = FindDescendantWindow (helpWindow, help_tool_bar)
if winHandle then
	if GetWindowClass (winHandle) == wc_toolbar then
		return winHandle
	EndIf
EndIf
return 0
EndFunction

Void Function HelpToolBar (handle helpWindow)
var
	handle winHandle,
	string firstButton,
	int item
let winHandle = GetHelpToolbar (HelpWindow)
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg_ToolbarNotFound, ot_message)
	return
EndIf
SaveCursor ()
InvisibleCursor ()
MoveToWindow (winHandle)
let firstButton = GetWord ()
RestoreCursor ()
if (firstButton == "Hide") then
	let item = dlgSelectItemInList (strToolbar1, HelpToolbarDialogName, true)
else
	let item = dlgSelectItemInList (strToolbar2, HelpToolbarDialogName, true)
EndIf
let nSuppressEcho = true
delay (2)
if ((item == Hide) && (firstButton == "Hide")) then
	ClickToolBarButton (winHandle, "Hide")
elif ((item == Show) && (firstButton == "Show")) then
	ClickToolBarButton (winHandle, "Show")
elif (item == Back) then
	ClickToolBarButton (winHandle, "Back")
elif (item == helpForward) then
	ClickToolBarButton (winHandle, "Forward")
elif (item == Options) then
	ClickToolBarButton (winHandle, "Options")
elif (item == Web) then
	ClickToolBarButton (winHandle, "Web")
EndIf
let nSuppressEcho = false
EndFunction

Void Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + " button not found ", ot_control_name)
EndIf
EndFunction

Script NextMessage () ;Moves to next message within the message window and anounces the from and subject fields prior to reading.
var
	int iVCursor,
	handle hwnd,
	string theClass,
	int verbosity
{Control + .}
	Say(msg_NextMessage, ot_message)
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
/*if (TheClass == ie4Class) then
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	; Check against state of initial VCursor setting to IEUpdate if was set to 1
	If (iVCursor == 1) then
		; Insert Refresh here, as IEUpdate does not redraw screen.  
		; Although a performance hit, it allows navigation keys to properly report the current message, not the previous 
		; as has been reported
		Refresh ()
	EndIf
	let nSuppressEcho = false
EndIf*/
EndScript

Script PreviousMessage () ;Reads previous message from within the message Window and anounces the from and subject fieleds prior to reading
var
	int iVCursor,
	handle hwnd,
	string theClass,
	int verbosity
{Control + ,}
Say(msg_PreviousMessage, ot_message)
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
/*if (TheClass == ie4Class) then
	let iVCursor = GetJcfOption (OPT_VIRTUAL_PC_CURSOR)
	let nSuppressEcho = true
	delay (3)
	let verbosity = GetVerbosity ()
	while (GetVerbosity () != intermediate)
		VerbosityLevel ()
	EndWhile
	PerformScript ReadFromField()
	PerformScript ReadSubjectField()
	while (GetVerbosity () != verbosity)
		VerbosityLevel ()
	EndWhile
	SayWindow (hwnd, read_everything)
	; Check against state of initial VCursor setting to IEUpdate if was set to 1
	If (iVCursor == 1) then
		; Insert Refresh here, as IEUpdate does not redraw screen.  
		; Although a performance hit, it allows navigation keys to properly report the current message, not the previous 
		; as has been reported
		Refresh ()
	EndIf
	let nSuppressEcho = false
EndIf*/
EndScript

Script DeleteMessage ();Deletes current message from within the message window, reads from and subject fields prior to reading next message.
var
	int iVState, ; intended to replace CaretVisible due to highlightedText, 
; temporarily flip on VCursor if off and after check condition restore it to its natural state
	int iVCursor, ; initial state of VCursor
	handle hwnd,
	string theClass,
	int verbosity
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
If (TheClass == wc_List) then
	Say(msg_DeleteMessage, ot_message)
	{control+d}
	Pause ()
	Return
EndIf
;Handle IEServer windows with vCursor
If (TheClass == IE4Class) then
let iVCursor = GetJcfOption (OPT_VIRTUAL_PC_CURSOR)
	If (iVCursor == 0) then
		SetJcfOption (OPT_VIRTUAL_PC_CURSOR, 1)
	EndIf
	if (IsVirtualPcCursor ()) then
		let iVState = 1
	Else
		let iVState = 0
	EndIf
	SetJcfOption (OPT_VIRTUAL_PC_CURSOR, iVCursor)
	; Now, check for VCursor instead of CaretVisible
	If (iVState == 1) then
		Say(msg_DeleteMessage, ot_message)
		;{delete} doesn't appear to work in Outlook Express 5 anymore
		{control+d}
		If (iVCursor == 0) then
			let nSuppressEcho = true
			delay (3)
			let hwnd = GetFocus ()
			Let TheClass = GetWindowClass (hwnd)
			if (TheClass == Ie4Class ) then
				let verbosity = GetVerbosity ()
				while (GetVerbosity () != intermediate)
					VerbosityLevel ()
				EndWhile
				PerformScript ReadFromField()
				PerformScript ReadSubjectField()
				SayWindow (hwnd, read_everything)
				while (GetVerbosity () != verbosity)
					VerbosityLevel ()
				EndWhile
			EndIf
			let nSuppressEcho = false
		EndIf
		Return
	EndIf
	SetJcfOption (OPT_VIRTUAL_PC_CURSOR, iVCursor)
EndIf
EndScript

Script GotoNextUnreadMessage () ;moves to next unread message and anounces from and subject fields prior to reading. 
var
	int iVCursor,
	handle hwnd,
	string theClass,
	int verbosity
Say(msg_GotoNextUnreadMessage, ot_message)
{Control + U}
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let iVCursor = GetJcfOption (OPT_VIRTUAL_PC_CURSOR)
	If (iVCursor == 0) then
		let nSuppressEcho = true
		delay (3)
		let verbosity = GetVerbosity ()
		while (GetVerbosity () != intermediate)
			VerbosityLevel ()
		EndWhile
		PerformScript ReadFromField()
		PerformScript ReadSubjectField()
		while (GetVerbosity () != verbosity)
			VerbosityLevel ()
		EndWhile
		SayWindow (hwnd, read_everything)
		let nSuppressEcho = false
	EndIf
EndIf
EndScript

Script GotoNextThread () ;moves to next thread. 
var
	int iVCursor,
	handle hwnd,
	string theClass,
	int verbosity
Say(msg_GotoNextThread, ot_message)
{Control + Shift + U}
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie4Class) then
	let iVCursor = GetJcfOption (OPT_VIRTUAL_PC_CURSOR)
	If (iVCursor == 0) then
		let nSuppressEcho = true
		delay (3)
		let verbosity = GetVerbosity ()
		while (GetVerbosity () != intermediate)
			VerbosityLevel ()
		EndWhile
		PerformScript ReadFromField()
		PerformScript ReadSubjectField()
		while (GetVerbosity () != verbosity)
			VerbosityLevel ()
		EndWhile
		PcCursor ()
		SayWindow (hwnd, read_everything)
		let nSuppressEcho = false
	EndIf
EndIf
EndScript

Script SayNextLine () ;says subscribed when down arrowing through the listview when in the newsgroup dialog
var
int TheTypeCode,
	string sClass
NextLine()
if (IsLeftButtonDown ()) then
SelectingText(TRUE)
pause ()
SelectingText(false)
return
EndIf
if not IsPCCursor () then
SayLine ()
return
EndIf
let sClass = GetWindowClass (GetCurrentWindow ())
If (sClass == 	wc_List) then
	Return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
SayWord ()
return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
SayWord()
return
EndIf
if CaretVisible () then
SayLine ()
return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
If (TheTypeCode == WT_TREEVIEW) then
	SayTreeViewLevel ()
	Return
EndIf
If ((TheTypeCode == WT_MULTISELECT_LISTBOX) ||
(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
if TheTypeCode == WT_TREEVIEW then SayTreeViewLevel () EndIf
SayLine()
endif
if (TheTypeCode == WT_LISTVIEW) then
if (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), wn3)) then
SayLine ()
EndIf
EndIf
EndScript

Script SayPriorLine () ;Says subscribed when up arrowing through the list view in the newsgroup dialog
var
int TheTypeCode,
	string sClass
PriorLine()
if (IsLeftButtonDown ()) then
SelectingText(TRUE)
pause ()
SelectingText(false)
return
EndIf
if not IsPCCursor () then
SayLine ()
return
EndIf
let sClass = GetWindowClass (GetCurrentWindow ())
If (sClass == 	wc_List) then
	Return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
SayWord ()
return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
SayWord()
return
EndIf
if CaretVisible () then
SayLine ()
return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
If (TheTypeCode == WT_TREEVIEW) then
	SayTreeViewLevel ()
	Return
EndIf
If ((TheTypeCode == WT_MULTISELECT_LISTBOX) ||
(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
if TheTypeCode == WT_TREEVIEW then SayTreeViewLevel () EndIf
SayLine()
endif
if (TheTypeCode == WT_LISTVIEW) then
if (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), wn3)) then
SayLine ()
EndIf
EndIf
EndScript

Script ReadCurrentScreen ()
var
	int iVState,
	handle hFocus,
	string sCurrentClass
let iVState = IsVirtualPCCursor ()
If (iVState == 0) then
	let hFocus = GetFocus ()
	let sCurrentClass = GetWindowClass (GetFocus ())
	If (sCurrentClass == IE4Class) then
		let nSuppressEcho = true
		MoveToWindow (hFocus)
		JawsCursor ()
		SayAll ()
		let nSuppressEcho = false
	Else
		Say (msg_NoOpenMessage, OT_MESSAGE)
	EndIf
Else
	Say (msg60, OT_MESSAGE); "not available in virtual PC cursor mode"
EndIf
EndScript

Script ReadNextScreen ()
let nSuppressEcho = true
{PageDown}
PerformScript ReadCurrentScreen ()
let nSuppressEcho = false
EndScript

Script ReadPriorScreen ()
{PageUp}
PerformScript ReadCurrentScreen ()
EndScript

HANDLE Function GetHelpWindow ()
var
	handle hwnd
let hwnd = GetTopLevelWindow (GetFocus ())
if (GetWindowName (hwnd) == wn_help) then
	return hwnd
else
	return 0
EndIf
EndFunction

HANDLE Function GetHelpTabControl (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_tab_control)
if winHandle then
	if GetWindowClass (winHandle) == "SysTabControl32" then
		return winHandle
	EndIf
EndIf
return 0
EndFunction

Script SelectHelpTab ()
var
	handle winHandle,
	int item
let winHandle = GetHelpWindow ()
if winHandle then
	let winHandle = GetHelpTabControl (winHandle)
	if (!winHandle || !IsWindowVisible (winHandle)) then
		;Say(msg_TabControlNotFound, ot_control_name)
		PerformScript StartJawsTaskList()
		return
	EndIf
	let item = dlgSelectItemInList (strTabControl, SelectTabDialogName, true)
	let nSuppressEcho = true
	delay (2)
	if (item == Contents) then
	;	{alt + c}
		ClickTab (winHandle, "Contents")
	elif (item == Index) then
	;	{alt + i}
		ClickTab (winHandle, "Index")
	elif (item == Search) then
	;	{alt + s}
		ClickTab (winHandle, "Search")
	EndIf
	let nSuppressEcho = false
else
	StartJawsTaskList ()
EndIf
EndScript

Void Function ClickTab (handle winHandle, string tab)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, tab, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(tab + msg_TabNotFound, ot_control_name)
EndIf
EndFunction

HANDLE Function GetContentsTreeView (handle helpWindow)
var
	handle hwnd
let hwnd = GetFirstChild (GetHelpTabControl (helpWindow))
if hwnd then
	if IsWindowVisible (hwnd) then
		if GetWindowClass (hwnd) == "SysTreeview32" then 
			return hwnd
		EndIf
	EndIf
EndIf
return 0
EndFunction

HANDLE Function GetHelpIndexEdit (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_index_edit)
if winHandle then
	if IsWindowVisible (winHandle) then
		if GetWindowClass (winHandle) == "Edit" then
			return winHandle
		EndIf
	EndIf
EndIf
return 0
EndFunction

HANDLE Function GetHelpSearchEdit (handle helpWindow)
var
	handle winHandle
let winHandle = FindDescendantWindow (helpWindow, help_search_edit)
if winHandle then
	if IsWindowVisible (winHandle) then
		if GetWindowClass (winHandle) == "Edit" then
			return winHandle
		EndIf
	EndIf
EndIf
return 0
EndFunction

Int Function GetHelpPage (handle helpWindow)
if GetContentsTreeView (helpWindow) then
	return Contents
elif GetHelpIndexEdit (helpWindow) then
	return Index
elif GetHelpSearchEdit (helpWindow) then
	return Search
EndIf
return 0
EndFunction

Script NextDocumentWindow () 
var
	handle helpWindow,
	int page
let helpWindow = GetHelpWindow ()
if helpWindow then
	if GetWindowClass (GetFocus ()) == IE4Class then
		let page = GetHelpPage (helpWindow)
		if (page == Contents) then
			{alt + c}
		elif (page == Index) then
			{alt + i}
		elif (page == Search) then
			{alt + s}
		EndIf
		return
	EndIf
EndIf
{control+tab}
delay (1)
if (IsMultiPageDialog ()) then
	Say(GetDialogPageName (), ot_dialog_name)
	return
endif
EndScript

Script PreviousDocumentWindow() 
var
	handle helpWindow,
	int page
let helpWindow = GetHelpWindow ()
if helpWindow then
	if GetWindowClass (GetFocus ()) == IE4Class then
		let page = GetHelpPage (helpWindow)
		if (page == Contents) then
			{alt + c}
		elif (page == Index) then
			{alt + i}
			{tab}
			{tab}
		elif (page == Search) then
			{alt + s}
			{tab}
			{tab}
			{tab}
		EndIf
		return
	EndIf
EndIf
{control+shift+tab}
Delay (1)
if (IsMultiPageDialog ()) then
	Say(GetDialogPageName (), ot_dialog_name)
	return
endif
EndScript

Script ToolBar ()
var
	handle winHandle,
	int item
let winHandle = GetHelpWindow ()
if winHandle then
	HelpToolBar (winHandle)
	return
EndIf
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msg_ToolbarNotFound, ot_message); "Tool bar not found"
	return
EndIf
let item = dlgSelectItemInList (strToolbar, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == Compose) then
	ClickToolBarButton (winHandle, "New Mail")
elif (item == Reply) then
	ClickToolBarButton (winHandle, "Reply")
elif (item == ReplyToAll) then
	ClickToolBarButton (winHandle, "Reply All")
elif (item == Forward) then
	ClickToolBarButton (winHandle, "Forward")
elif (item == Send) then
	ClickToolBarButton (winHandle, "Send")
elif (item == Delete) then
	ClickToolBarButton (winHandle, "Delete")
elif (item == Address) then
	ClickToolBarButton (winHandle, "Address")
EndIf
let nSuppressEcho = false
EndScript

Script JawsDelete ()
; See implementation of VCursor in DeleteMessage script, as synonymous
var
	int iVState,
	int iVCursor,
	handle hwnd,
	string theClass,
	int verbosity
let hwnd = GetFocus ()
Let TheClass = GetWindowClass (hwnd)
If (TheClass == wc_List) then
	Say(msg_DeleteMessage, ot_message)
	{delete}
	Pause ()
	Return
EndIf
	If (TheClass == IE4Class) then
	let iVCursor = GetJcfOption (OPT_VIRTUAL_PC_CURSOR)
	If (iVCursor == 0) then
		SetJcfOption (OPT_VIRTUAL_PC_CURSOR, 1)
	EndIf
	If (IsVirtualPcCursor ()) then
		let iVState = 1
	Else
		let iVState = 0
	EndIf
	SetJcfOption (OPT_VIRTUAL_PC_CURSOR, iVCursor)
	If (iVState == 1) then
		Say(msg_DeleteMessage, ot_message)
		;{delete} doesn't appear to work in Outlook Express 5 anymore
		{control+d}
		If (iVCursor == 0) then ; let's look at the actual state of vCursor setting
			let nSuppressEcho = true
			SayString ("Start delay")
			delay (3)
			SayString ("End Delay")
			let hwnd = GetFocus ()
			Let TheClass = GetWindowClass (hwnd)
			if (TheClass == Ie4Class ) then
				let verbosity = GetVerbosity ()
				while (GetVerbosity () != intermediate)
					VerbosityLevel ()
				EndWhile
				PerformScript ReadFromField()
				PerformScript ReadSubjectField()
				while (GetVerbosity () != verbosity)
					VerbosityLevel ()
				EndWhile
				SayWindow (hwnd, read_everything)
			EndIf
			let nSuppressEcho = false
		EndIf
		Return
	EndIf
	SetJcfOption (OPT_VIRTUAL_PC_CURSOR, iVCursor)
EndIf
PerformScript JawsDelete ()
EndScript
Function WindowCreatedEvent(handle hwnd)
if (GetWindowClass(hwnd) == "Internet Explorer_Server") then
let oe_hWindowNewHTMLDocument = hwnd
EndIf
EndFunction
